/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.ui;

import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.ai.msg.Telegram;
import com.badlogic.gdx.ai.msg.Telegraph;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import technology.rocketjump.undermount.ui.GameInteractionMode;
import technology.rocketjump.undermount.ui.GameInteractionStateContainer;
import technology.rocketjump.undermount.ui.StageAreaOnlyInputHandler;
import technology.rocketjump.undermount.ui.cursor.CursorManager;
import technology.rocketjump.undermount.ui.skins.GuiSkinRepository;
import technology.rocketjump.undermount.ui.views.GuiView;
import technology.rocketjump.undermount.ui.views.GuiViewName;
import technology.rocketjump.undermount.ui.views.GuiViewRepository;

@Singleton
public class GuiContainer
implements Telegraph,
Disposable {
    private final Table containerTable;
    private final MessageDispatcher messageDispatcher;
    private final CursorManager cursorManager;
    private final GameInteractionStateContainer interactionStateContainer;
    private Stage stage;
    private StageAreaOnlyInputHandler stageAreaOnlyInputHandler;
    private final GuiViewRepository guiViewRepository;
    private GuiViewName currentViewName;
    private GuiView currentView;
    private float timeSinceLastUpdate = 0.0f;

    @Inject
    public GuiContainer(MessageDispatcher messageDispatcher, CursorManager cursorManager, GameInteractionStateContainer interactionStateContainer, GuiSkinRepository guiSkinRepository, GuiViewRepository guiViewRepository) {
        Skin uiSkin = guiSkinRepository.getDefault();
        this.cursorManager = cursorManager;
        this.interactionStateContainer = interactionStateContainer;
        this.stage = new Stage(new ScreenViewport());
        this.stageAreaOnlyInputHandler = new StageAreaOnlyInputHandler(this.stage);
        this.containerTable = new Table(uiSkin);
        this.containerTable.setFillParent(true);
        this.containerTable.pad(10.0f);
        this.containerTable.left().bottom();
        this.stage.addActor(this.containerTable);
        this.messageDispatcher = messageDispatcher;
        messageDispatcher.addListener(this, 251);
        messageDispatcher.addListener(this, 252);
        messageDispatcher.addListener(this, 253);
        this.guiViewRepository = guiViewRepository;
        this.switchView(GuiViewName.DEFAULT_MENU);
    }

    @Override
    public void dispose() {
        this.messageDispatcher.removeListener((Telegraph)this, 251);
        this.messageDispatcher.removeListener((Telegraph)this, 252);
        this.messageDispatcher.removeListener((Telegraph)this, 253);
    }

    @Override
    public boolean handleMessage(Telegram msg) {
        switch (msg.message) {
            case 251: {
                GuiViewName targetView = (GuiViewName)((Object)msg.extraInfo);
                this.switchView(targetView);
                return true;
            }
            case 252: {
                GameInteractionMode targetMode = (GameInteractionMode)((Object)msg.extraInfo);
                this.cursorManager.switchToCursor(targetMode.cursorName);
                this.interactionStateContainer.setInteractionMode(targetMode);
                return true;
            }
            case 253: {
                if (this.currentViewName.equals((Object)GuiViewName.ORDER_SELECTION) || this.currentViewName.equals((Object)GuiViewName.ROOM_SELECTION)) {
                    this.switchView(GuiViewName.DEFAULT_MENU);
                } else if (this.currentViewName.equals((Object)GuiViewName.ROOM_SIZING)) {
                    this.switchView(GuiViewName.ROOM_SELECTION);
                } else if (this.currentViewName.equals((Object)GuiViewName.ROOM_FURNITURE_SELECTION)) {
                    this.switchView(GuiViewName.ROOM_SIZING);
                } else if (this.currentViewName.equals((Object)GuiViewName.ENTITY_SELECTED)) {
                    this.switchView(GuiViewName.DEFAULT_MENU);
                } else if (!this.currentViewName.equals((Object)GuiViewName.DEFAULT_MENU)) {
                    System.err.println("Don't know how to cancel current view from " + this.currentViewName.name());
                }
                return true;
            }
        }
        throw new IllegalArgumentException("Unexpected message type " + msg.message + " received by " + this.toString() + ", " + msg.toString());
    }

    public void update(float deltaTime) {
        this.stage.act(deltaTime);
        this.timeSinceLastUpdate += deltaTime;
        if (this.timeSinceLastUpdate > 1.0f) {
            this.timeSinceLastUpdate = 0.0f;
            if (this.currentView != null) {
                this.currentView.update();
            }
        }
    }

    public void render() {
        this.stage.draw();
    }

    public void onResize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
    }

    public InputProcessor getInputProcessor() {
        return this.stageAreaOnlyInputHandler;
    }

    private void switchView(GuiViewName viewName) {
        GuiView newView = this.guiViewRepository.getByName(viewName);
        if (newView == null) {
            System.err.println("No GuiView defined for " + viewName.name());
        } else {
            this.currentViewName = viewName;
            this.containerTable.clear();
            newView.populate(this.containerTable);
        }
        this.currentView = newView;
    }
}

